#ifndef __IScrollListener__
#define __IScrollListener__

#include "../Events/CScrollEvent.hpp"
using Exponent::GUI::Events::CScrollEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IScrollListener IScrollListener.hpp
			 * @brief Allows for responding to scroll bar movements
			 *
			 * @date 19/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IScrollListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IScrollListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IScrollListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IScrollListener() { }

//	===========================================================================

				/**
				 * Handle a scroll event
				 * @param event The evnt to handle
				 */
				virtual void handleScrollEvent(const CScrollEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IScrollListener.hpp